import { TrendingUp, TrendingDown, Star } from "lucide-react";
import { Button } from "@/components/ui/button";

const cryptoData = [
  {
    id: 1,
    name: "Bitcoin",
    symbol: "BTC",
    price: 67432.50,
    change: 2.34,
    volume: "28.5B",
    marketCap: "1.32T",
    color: "#F7931A",
  },
  {
    id: 2,
    name: "Ethereum",
    symbol: "ETH",
    price: 3456.78,
    change: -1.23,
    volume: "15.2B",
    marketCap: "415B",
    color: "#627EEA",
  },
  {
    id: 3,
    name: "Solana",
    symbol: "SOL",
    price: 178.45,
    change: 5.67,
    volume: "4.8B",
    marketCap: "78B",
    color: "#00FFA3",
  },
  {
    id: 4,
    name: "Cardano",
    symbol: "ADA",
    price: 0.89,
    change: -0.45,
    volume: "1.2B",
    marketCap: "31B",
    color: "#0033AD",
  },
  {
    id: 5,
    name: "Avalanche",
    symbol: "AVAX",
    price: 42.30,
    change: 3.21,
    volume: "890M",
    marketCap: "16B",
    color: "#E84142",
  },
  {
    id: 6,
    name: "Polygon",
    symbol: "MATIC",
    price: 1.12,
    change: 1.89,
    volume: "650M",
    marketCap: "10B",
    color: "#8247E5",
  },
];

const CryptoTable = () => {
  return (
    <section className="py-20 relative">
      <div className="container mx-auto px-4">
        {/* Section Header */}
        <div className="flex flex-col md:flex-row md:items-center justify-between mb-10">
          <div>
            <h2 className="text-3xl md:text-4xl font-bold text-foreground mb-2">
              Mercados populares
            </h2>
            <p className="text-muted-foreground">
              Los activos más negociados en las últimas 24 horas
            </p>
          </div>
          <Button variant="outline" className="mt-4 md:mt-0">
            Ver todos los mercados
          </Button>
        </div>

        {/* Table */}
        <div className="glass rounded-2xl overflow-hidden">
          {/* Table Header */}
          <div className="hidden md:grid grid-cols-12 gap-4 p-4 border-b border-border text-sm text-muted-foreground font-medium">
            <div className="col-span-1"></div>
            <div className="col-span-3">Activo</div>
            <div className="col-span-2 text-right">Precio</div>
            <div className="col-span-2 text-right">Cambio 24h</div>
            <div className="col-span-2 text-right">Volumen</div>
            <div className="col-span-2 text-right">Acción</div>
          </div>

          {/* Table Rows */}
          {cryptoData.map((crypto, index) => (
            <div
              key={crypto.id}
              className="grid grid-cols-1 md:grid-cols-12 gap-4 p-4 border-b border-border/50 last:border-0 hover:bg-secondary/30 transition-colors animate-fade-in"
              style={{ animationDelay: `${index * 0.05}s` }}
            >
              {/* Favorite */}
              <div className="hidden md:flex col-span-1 items-center">
                <Star className="w-5 h-5 text-muted-foreground hover:text-warning cursor-pointer transition-colors" />
              </div>

              {/* Asset Info */}
              <div className="col-span-3 flex items-center gap-3">
                <div
                  className="w-10 h-10 rounded-full flex items-center justify-center text-white font-bold text-sm"
                  style={{ backgroundColor: crypto.color }}
                >
                  {crypto.symbol.charAt(0)}
                </div>
                <div>
                  <div className="font-semibold text-foreground">{crypto.name}</div>
                  <div className="text-sm text-muted-foreground">{crypto.symbol}</div>
                </div>
              </div>

              {/* Price */}
              <div className="col-span-2 flex items-center md:justify-end">
                <div className="md:text-right">
                  <div className="font-semibold text-foreground">
                    ${crypto.price.toLocaleString('en-US', { minimumFractionDigits: 2 })}
                  </div>
                  <div className="text-sm text-muted-foreground md:hidden">Precio</div>
                </div>
              </div>

              {/* Change */}
              <div className="col-span-2 flex items-center md:justify-end">
                <div className={`flex items-center gap-1 ${crypto.change >= 0 ? 'text-success' : 'text-destructive'}`}>
                  {crypto.change >= 0 ? (
                    <TrendingUp className="w-4 h-4" />
                  ) : (
                    <TrendingDown className="w-4 h-4" />
                  )}
                  <span className="font-medium">
                    {crypto.change >= 0 ? '+' : ''}{crypto.change}%
                  </span>
                </div>
              </div>

              {/* Volume */}
              <div className="col-span-2 flex items-center md:justify-end">
                <div className="text-foreground font-medium">${crypto.volume}</div>
              </div>

              {/* Action */}
              <div className="col-span-2 flex items-center justify-end gap-2">
                <Button variant="success" size="sm">
                  Comprar
                </Button>
                <Button variant="outline" size="sm">
                  Vender
                </Button>
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
};

export default CryptoTable;
